# Visualization in Grafana

## 1. Device Dashboard
This dashboard displays the latest information of a device like device details, latest observations, device state transitions.
This dashboard uses the IDS **current** APIs to retrieve the data related to the device.  

## 2. Device Job History ##
This dashboard displays a table of history of device jobs results of a specific device.

Optional filters available:
- **Status**: Status of the job.
- **Primitive**: Job Primitive. Status is mandatory, if this filter is used.
- **Job ID**: Job ID. Status and Primitive are mandatory if this filter is used.

## 3. SMS Delivery Reports ##
This dashboard displays the historical SMS Delivery Reports for a specific device. 
The reports can be filtered with the following options:
- **requestId**: A comma separated requestIds can be specified.
- **status**: Multi-select drop-down to filter out reports based on different statuses.

## 4. Monte Events ##
This dashboard displays the historical MONTE events of a specific device.
The events can be filtered with the following options:
- **subscriptionId**: A comma separated subscriptionIds can be specified.
- **eventType**: Multi-select drop-down to filter out reports based on different event Types. This filter can be used 
  when the subscriptionId filter is applied. 

## 5. Alert Events ##
This dashboard displays a table of alerts of a specific device.

Optional filters available:
- **Rule**: Rule Name
- **Severity**: Severity of the alert. Rule is mandatory, if this filter is used.

## 6. Aggregation Events ##
This dashboard displays a table of aggregation events generated for specified rule(s).

Optional filters available:
- **Metric**: Metric to filter with.

## 7. Utility Device Dashboard(Water Metering Device)
This dashboard displays the basic device details and graphs for actual, average and estimated meter reading of a water meter.
The user has to input the below fields in the dashboard:
  - DeviceId
  - Meter Reading Extraction Rule ID
  - Average Meter Reading Rule ID
  - Estimation Rule ID

## 8. Supported Events
This dashboard displays the events and their keys supported by IDS. This can be used to build the API urls of 
dynamic v2 APIs.

**Exa:**

The following template can be used and the fields can be replaced like shown below

**From**: /ids-data-api/v2/current/**{event}**?<**key1**>=<value1>&<**key2**>=values2

**To**o: /ids-data-api/v2/current/observation_event?serialnumber=666666&resourcepath=/device/0/temp

## 9. Rules 
This dashboard displays the rules configured in the system. 


## 10. Billing Dashboard
This dashboard displays the impact billing records.